package Repository;

import database.MongoDBConnector;
import objects.Task;
import org.bson.Document;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * Created by gpietrus on 20.02.2016.
 */
public class TasksRepository implements Repository {

    private MongoDBConnector mongoDBConnector;

    public TasksRepository(MongoDBConnector mongoDBConnector) {
        this.mongoDBConnector = mongoDBConnector;
    }

    public void get(UUID uuid) {

    }

    public List<Task> getAll() {
        return mongoDBConnector.getCollection("tasks")
                .stream()
                .map(Task::new)
                .collect(Collectors.toList());
    }

    public void add(Task task) {
        mongoDBConnector.addDocument("tasks", new Document(task.toMap()));
    }

    public void clean() {
        mongoDBConnector.removeCollection("tasks");
    }
}

//todo: generify!