import Repository.SolutionsRepository;
import Repository.TasksRepository;
import Repository.TeamsRepository;
import Repository.UsersRepository;
import api.ProxyResource;
import api.TasksResource;
import api.TeamsResource;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import core.TaskType;
import database.MongoDBConnector;
import io.dropwizard.Application;
import io.dropwizard.setup.Environment;
import objects.Flag;
import objects.Task;
import objects.Team;
import objects.User;

import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;

/**
 * Created by gpietrus on 16.02.16.
 */
public class CTFApplication extends Application<ApplicationConfiguration> {

    @Override
    public void run(ApplicationConfiguration applicationConfiguration, Environment environment) throws Exception {

        MongoDBConnector dbConnector = new MongoDBConnector();
        dbConnector.connect();

        //CREATE SOLUTION REPOSITORY
        SolutionsRepository solutionsRepository = new SolutionsRepository(dbConnector);

//        UsersRepository usersRepository = new UsersRepository(dbConnector);//todo: use injections

        //GENERATE TEAMS

        TeamsRepository teamsRepository = new TeamsRepository(dbConnector);
        teamsRepository.clean();

        int numberOfNewTeams = new Random().nextInt(20);
        int numberOfTeamMembers = 3;

        for (int i = 0; i < numberOfNewTeams; i++) {

            ArrayList<User> members = new ArrayList<>();
            for (int j = 0; j < numberOfTeamMembers; j++) {
                members.add(new User(String.valueOf(UUID.randomUUID()), "passwd", "email"));
            }

            teamsRepository.add(new Team(String.valueOf(UUID.randomUUID()), "description", members));
        }

        //GENERATE TEAMS END

        //GENERATE TASKS

        TasksRepository tasksRepository = new TasksRepository(dbConnector);
        tasksRepository.clean();

        int numberOfNewTasks = 20;

        for(int i = 0; i < 20; i++) {
            Task task = new Task(String.valueOf(UUID.randomUUID()), i,
                    i % 2 == 0 ? TaskType.CRYPTO : TaskType.WEB,
                    Flag.newRandomFlag()
            );
            tasksRepository.add(task);
        }

        //GENERATE TASKS END

        //REGISTER RESOURCES

//        environment.jersey().register(new UsersResource(usersRepository));
        environment.jersey().register(new TeamsResource(teamsRepository));
        environment.jersey().register(new TasksResource(tasksRepository, teamsRepository, solutionsRepository));
        environment.jersey().register(new ProxyResource());
    }

    private Injector createInjector(UsersRepository usersRepository) {
        return Guice.createInjector(new AbstractModule() {
            @Override
            protected void configure() {
                bind(UsersRepository.class).toInstance(usersRepository);
            }
        });
    }

    public static void main(String[] args) throws Exception {
        //todo: add mongo-java-driver as maven dep
        new CTFApplication().run(args);
    }
}
