import Repository.UsersRepository;
import api.UsersResource;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import database.MongoDBConnector;
import io.dropwizard.Application;
import io.dropwizard.setup.Environment;
import objects.User;

import java.util.Random;
import java.util.UUID;

/**
 * Created by gpietrus on 16.02.16.
 */
public class CTFApplication extends Application<ApplicationConfiguration> {

    @Override
    public void run(ApplicationConfiguration applicationConfiguration, Environment environment) throws Exception {

        MongoDBConnector mongoDBConnector = new MongoDBConnector();
        mongoDBConnector.connect();

        UsersRepository usersRepository = new UsersRepository(mongoDBConnector);//todo: use injections
        usersRepository.clean(); //todo

        int numberOfNewUsers = new Random().nextInt(50);
        for (int i = 0; i < numberOfNewUsers; i++) {
            User user = new User(String.valueOf(UUID.randomUUID()), "mehow");
            usersRepository.add(user);
        }

//        Injector injector = createInjector(usersRepository);

//        final LifecycleEnvironment lifecycleEnvironment = environment.lifecycle();
//
//        lifecycleEnvironment.manage((Managed) );

        environment.jersey().register(new UsersResource(usersRepository));
    }

    private Injector createInjector(UsersRepository usersRepository) {
        return Guice.createInjector(new AbstractModule() {
            @Override
            protected void configure() {
                bind(UsersRepository.class).toInstance(usersRepository);
            }
        });
    }
    public static void main(String[] args) throws Exception {
        //todo: add mongo-java-driver as maven dep
        new CTFApplication().run(args);
    }
}
