package com.telephoners.krakyournet.ctf.beans.tasks;

import com.telephoners.krakyournet.ctf.beans.User;
import org.eclipse.jetty.http.HttpMethod;

import java.util.Map;

public class TaskRequestContext
{
    private HttpMethod httpMethod; //todo: use class
    private User user;
    private String path;
    private String body;
    private Map<String, String> headers;

    public TaskRequestContext withHttpMethod(HttpMethod httpMethod)
    {
        this.httpMethod = httpMethod;
        return this;
    }

    public TaskRequestContext withUser(User user)
    {
        this.user = user;
        return this;
    }

    public TaskRequestContext withPath(String path)
    {
        this.path = path;
        return this;
    }

    public TaskRequestContext withBody(String body) {
        this.body = body;
        return this;
    }

    public TaskRequestContext withHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public HttpMethod getHttpMethod()
    {
        return httpMethod;
    }

    public User getUser()
    {
        return user;
    }

    public String getPath()
    {
        return path;
    }

    public String getBody()
    {
        return body;
    }

    public Map<String, String> getHeaders()
    {
        return headers;
    }
}
