package com.telephoners.krakyournet.ctf.resources;

import com.google.common.base.Joiner;
import com.telephoners.krakyournet.ctf.beans.User;
import com.telephoners.krakyournet.ctf.beans.tasks.Task;
import com.telephoners.krakyournet.ctf.repositories.TasksRepository;
import io.dropwizard.auth.Auth;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import java.io.IOException;

@Singleton
@Path(value = "/task")
public class TaskResource
{
    private final TasksRepository tasksRepository;

    @Inject
    public TaskResource(TasksRepository tasksRepository)
    {
        this.tasksRepository = tasksRepository;
    }

    @Path("{task_level}/{path: .*}")
    @GET
    public Response getTask(@Auth User user,
                            final @PathParam("task_level") int taskLevel,
                            final @PathParam("path") String path) throws IOException
    {
        Task task = tasksRepository.getByLevel(taskLevel);
        //todo: refactor, path not necessary in textTasks
        return Response.ok().entity(task.getTextForUser(user, path)).build();
    }
}
