package com.telephoners.krakyournet.ctf.beans.tasks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.telephoners.krakyournet.ctf.beans.Flag;
import com.telephoners.krakyournet.ctf.helpers.PublicProperty;

import javax.ws.rs.core.Response;
import java.net.URISyntaxException;
import java.util.List;

@JsonInclude(JsonInclude.Include.NON_NULL)
public abstract class Task
{
    @PublicProperty
    private String name;
    @PublicProperty
    private String description;
    @PublicProperty
    private int level;
    private List<Flag> flags;

    public Task(String name, int level, String description, List<Flag> flags)
    {
        this.name = name;
        this.level = level;
        this.description = description;
        this.flags = flags;
    }

    public Task()
    {
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public int getLevel()
    {
        return level;
    }

    public void setLevel(int level)
    {
        this.level = level;
    }

    public List<Flag> getFlags()
    {
        return flags;
    }

    public void setFlags(List<Flag> flags)
    {
        this.flags = flags;
    }

    public String getDescription()
    {
        return description;
    }

    public void setDescription(String description)
    {
        this.description = description;
    }

    @JsonIgnore
    public abstract Response getTaskResponse() throws URISyntaxException;
}
