package stub;

import com.google.common.collect.Lists;
import com.mongodb.ServerAddress;
import org.mongolink.MongoSession;
import org.mongolink.MongoSessionManager;
import org.mongolink.Settings;
import org.mongolink.UpdateStrategies;
import org.mongolink.domain.mapper.ContextBuilder;

/**
 * Created by gpietrus on 16.02.16.
 */
public class MongoSth
{
    public void run() {
        ContextBuilder builder = new ContextBuilder("org.mongolink.example.persistence.mapping");
        Settings settings = Settings.defaultInstance()
                .withDefaultUpdateStrategy(UpdateStrategies.DIFF)
                .withDbName("db")
                .withAddresses(Lists.newArrayList(new ServerAddress("localhost", 27017)))
                .withAuthentication("user", "passwd");
        MongoSessionManager mongoSessionManager = MongoSessionManager.create(builder, settings);

        MongoSession session = mongoSessionManager.createSession();
        session.start();
// do stuff
        session.stop();
    }
}
