package com.telephoners.krakyournet.ctf.core;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.telephoners.krakyournet.ctf.beans.User;
import com.telephoners.krakyournet.ctf.providers.MessageDigestProvider;
import org.apache.commons.codec.binary.Hex;

@Singleton
public class HashValidator
{
    private ApplicationConfiguration applicationConfiguration;
    private MessageDigestProvider messageDigestProvider;

    @Inject
    public HashValidator(ApplicationConfiguration applicationConfiguration,
                         MessageDigestProvider messageDigestProvider)
    {
        this.applicationConfiguration = applicationConfiguration;
        this.messageDigestProvider = messageDigestProvider;
    }

    public String calculateHashValue(User user, String flagValue)
    {
        String combinedStrings = applicationConfiguration.getSalt() + user.getName() + flagValue;
        return Hex.encodeHexString(messageDigestProvider.getMessageDigest().digest(combinedStrings.getBytes()));
    }
}
