package com.telephoners.krakyournet.ctf.beans.tasks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.telephoners.krakyournet.ctf.beans.Flag;
import com.telephoners.krakyournet.ctf.beans.User;
import org.mongodb.morphia.annotations.Entity;

import javax.ws.rs.container.ContainerRequestContext;
import java.io.IOException;
import java.util.List;

@Entity("tasks")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class TextTask extends Task
{
    private String text;

    public TextTask(String name, int level, String description, List<Flag> flags, String text)
    {
        super(name, level, description, flags);
        this.text = text;
    }

    public TextTask()
    {
    }

    @Override
    public TaskResponse getTaskResponse(TaskRequestContext taskRequestContext) throws IOException
    {
        return new TaskResponse(text, null);
    }

    public void setText(String text)
    {
        this.text = text;
    }
}
