package com.telephoners.krakyournet.ctf.providers;

import com.telephoners.krakyournet.ctf.core.ApplicationConfiguration;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageDigestProvider
{
    private ApplicationConfiguration applicationConfiguration;

    public MessageDigestProvider(ApplicationConfiguration applicationConfiguration)
    {
        this.applicationConfiguration = applicationConfiguration;
    }

    public MessageDigest getMessageDigest()
    {
        try {
            return MessageDigest.getInstance(applicationConfiguration.getFlagHashMethod());
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }
}
