package com.telephoners.krakyournet.ctf.core;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.telephoners.krakyournet.ctf.beans.User;
import org.apache.commons.codec.binary.Hex;

import javax.inject.Named;
import java.security.MessageDigest;

@Singleton
public class HashValidator
{
    private ApplicationConfiguration applicationConfiguration;
    private MessageDigest messageDigest; //todo: use messageDigestProvider

    @Inject
    public HashValidator(ApplicationConfiguration applicationConfiguration,
                         final @Named("messageDigest") MessageDigest messageDigest)
    {
        this.applicationConfiguration = applicationConfiguration;
        this.messageDigest = messageDigest;
    }

    public String calculateHashValue(User user, String flagValue)
    {
        String combinedStrings = applicationConfiguration.getSalt() + user.getName() + flagValue;
        return Hex.encodeHexString(messageDigest.digest(combinedStrings.getBytes()));
    }
}
