package objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.bson.types.ObjectId;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.annotations.Reference;

import java.util.List;

/**
 * Created by gpietrus on 20.02.2016.
 */
@Entity("teams")
public class Team {
    @Id
    private ObjectId id;
    private String name;
    private String description;

    @Reference
    private List<User> members;

    @JsonCreator
    public Team(@JsonProperty("name") String name,
                @JsonProperty("description") String description,
                @JsonProperty("members") List<User> members) {
        this.name = name;
        this.description = description;
        this.members = members;
    }

    public Team() {
    }

    public ObjectId getId() {
        return id;
    }

    public void setId(ObjectId id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

}
