package com.telephoners.krakyournet.ctf.resources;

import com.telephoners.krakyournet.ctf.beans.tasks.Task;
import com.telephoners.krakyournet.ctf.repositories.TasksRepository;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.List;

@Singleton
@Path(value = "/tasks")
@Produces(MediaType.APPLICATION_JSON)
public class TasksResource
{
    private final TasksRepository tasksRepository;

    @Inject
    public TasksResource(TasksRepository tasksRepository)
    {
        this.tasksRepository = tasksRepository;
    }

    @GET
    public List<Task> getTasksPublic()
    {
        return tasksRepository.getAllPublic();
    }
}
