(function(){
    angular.module('ctfApp').controller('ScoreboardController', ['$scope', '$http', 'AppSettings', 'APIProvider', function($scope, $http, AppSettings, APIProvider) {

        var calculatePerTeam = function(data) {
            var teams = {};
            for (var team in data) {
                if (data.hasOwnProperty(team)) {
                    var task = data[team];
                    for(var i = 0; i < task.length; i++){
                        if (!teams[task[i]]){
                            teams[task[i]] = 1;
                        }
                        else {
                            teams[task[i]] += 1;
                        }
                    }
                }
            }
            return teams;
        };

        function viewGraph(){
            $('.column').css('height','0');
            // console.log($scope.teamsScores);
            setTimeout(function(){
                    $('.column').each(function(){
                        $(this).animate({width: 150*$(this).attr('data-score')}, 1500);
                    });
                }
            );
        }


        APIProvider.getScores(function(data){
            // console.log('Data from server', data);
            $scope.teamsScores = calculatePerTeam(data);
            // console.log('Teams scores', $scope.teamsScores);
            viewGraph();
        });





    }]);

})();