package com.telephoners.krakyournet.ctf.commands;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.telephoners.krakyournet.ctf.core.ApplicationConfiguration;
import com.telephoners.krakyournet.ctf.core.TaskType;
import com.telephoners.krakyournet.ctf.helpers.TextTaskConfig;
import com.telephoners.krakyournet.ctf.helpers.WebTaskConfig;
import com.telephoners.krakyournet.ctf.modules.ApplicationModule;
import com.telephoners.krakyournet.ctf.objects.Flag;
import com.telephoners.krakyournet.ctf.objects.tasks.Task;
import com.telephoners.krakyournet.ctf.objects.tasks.TaskCryptoContent;
import com.telephoners.krakyournet.ctf.objects.tasks.TaskWebContent;
import com.telephoners.krakyournet.ctf.repositories.TasksRepository;
import io.dropwizard.cli.ConfiguredCommand;
import io.dropwizard.setup.Bootstrap;
import net.sourceforge.argparse4j.inf.Namespace;

import java.util.List;
import java.util.stream.Collectors;

public class RegisterTasksCommand extends ConfiguredCommand<ApplicationConfiguration>
{
    private static final String COMMAND_NAME = "registertasks";
    private static final String COMMAND_DESCRIPTION = "Register tasks";

    public RegisterTasksCommand()
    {
        super(COMMAND_NAME, COMMAND_DESCRIPTION);
    }

    private void initializeTasks(ApplicationConfiguration applicationConfiguration, Injector injector)
    {
        TasksRepository tasksRepository = injector.getInstance(TasksRepository.class);

        List<TextTaskConfig> cryptoTasks = applicationConfiguration.getTextTasks();
        List<WebTaskConfig> webTasks = applicationConfiguration.getWebTasks();

        tasksRepository.clean();
        cryptoTasks.forEach(cryptoTaskConfig -> {

            cryptoTaskConfig.getFlags().stream()
                    .map(Flag::new)
                    .collect(Collectors.toList());

            tasksRepository.add(new Task(
                    cryptoTaskConfig.getName(),
                    cryptoTaskConfig.getLevel(),
                    TaskType.TEXT,
                    cryptoTaskConfig.getFlags().stream()
                            .map(Flag::new)
                            .collect(Collectors.toList()),
                    new TaskCryptoContent(cryptoTaskConfig.getText())
            ));
        });

        webTasks.forEach(webTaskConfig -> tasksRepository.add(new Task(
                webTaskConfig.getName(),
                webTaskConfig.getLevel(),
                TaskType.WEB,
                webTaskConfig.getFlags().stream()
                        .map(Flag::new)
                        .collect(Collectors.toList()),
                new TaskWebContent(webTaskConfig.getUrl())
        )));
    }

    @Override
    protected void run(Bootstrap<ApplicationConfiguration> bootstrap, Namespace namespace, ApplicationConfiguration applicationConfiguration) throws Exception
    {
        Injector injector = Guice.createInjector(new ApplicationModule(applicationConfiguration));
        initializeTasks(applicationConfiguration, injector);
    }
}
