(function () {

    angular.module('ctfApp').factory('NavbarService', [
        function () {
            var selector = '.title';
            var firstDomain = 'capture-the-flag';
            var secondDomain = 'capture-the-flAGH-2016';

            return {

                createNavbarString: function(username, domain){
                    return '<span class="username">'+username+'@</span><b>'+ (domain ? domain : secondDomain) +'</b>' + (domain ? ':~$' : '');
                },

                setUsername: function(username){
                    $(selector).html(this.createNavbarString(username));
                },

                setGuest: function(){
                    return this.setUsername('guest');
                },

                getTypedStrings: function(username){
                    return [this.createNavbarString(username, firstDomain), this.createNavbarString(username, secondDomain)];
                },

                getGuestTypedStrings: function(){
                    return this.getTypedStrings('guest');
                }

            };
        }]);
})();