package objects;

import com.google.common.collect.ImmutableMap;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.mongodb.morphia.annotations.Entity;

import java.util.Map;

/**
 * Created by gpietrus on 20.02.2016.
 */
@Entity("solutions")
public class Solution {
    private ObjectId id;
    private String taskName;
    private String teamId;

    public Solution(String teamId, String taskName) {
        this.teamId = teamId;
        this.taskName = taskName;
    }

    public Solution() {}

    public String getTaskName() {
        return taskName;
    }

    public String getTeamId() {
        return teamId;
    }

    public Solution(Document document) {
        this.taskName = document.get("taskName").toString(); //todo: refactor mapping
        this.teamId = document.get("teamId").toString();
    }

    //todo: refactor mapping
    public Map<String, String> toMap() {
        return ImmutableMap.<String, String>builder()
                .put("teamId",teamId)
                .put("taskName", taskName)
                .build();
    }
}
