package repositories;

import objects.Solution;
import org.mongodb.morphia.Datastore;

import javax.inject.Inject;
import javax.inject.Singleton;
import java.util.List;

/**
 * Created by gpietrus on 20.02.2016.
 */
@Singleton
public class SolutionsRepository implements Repository {
    private Datastore datastore;

    @Inject
    public SolutionsRepository(Datastore datastore) {
        this.datastore = datastore;
        initialize();
    }

    public List<Solution> getAll() {
        return datastore.createQuery(Solution.class).asList();
    }

    @Override
    public void initialize() {
        this.clean();
    }

    public void add(Solution solution) { //todo
        datastore.save(solution); //todo: error handling?
        //todo: do not add if already exists
    }

    public void clean() {
        datastore.getCollection(Solution.class).drop();
    }
}

//todo: generify!