package objects;

import com.google.common.collect.ImmutableMap;
import org.bson.Document;

import java.security.Principal;
import java.util.Map;

/**
 * Created by gpietrus on 16.02.16.
 */
public class User implements Principal {
    private String name;
    private String password;
    private String email;

    public User(Document document) {
        this.name = document.get("name").toString();
        this.password = document.get("password").toString();
        this.email = document.get("password").toString();
    }

//    public User() {
//        dummy constructor for json
//    }

    public User(String name, String password, String email) {
        this.name = name;
        this.password = password;
        this.email = email;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    //todo: refactor mapping
    public Map<String, Object> toMap() {
        return ImmutableMap.<String, Object>builder()
                .put("name", name)
                .put("password", password)
                .build();
    }

    //todo: contructor fromMap
}
