package objects;

import com.google.common.collect.ImmutableMap;
import org.bson.Document;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Created by gpietrus on 20.02.2016.
 */
public class Team {
    private String name;
    private String description;
    private List<User> members;

    public Team(Document document) {
        //todo: refactor mapping
        this.name = document.get("name").toString();
        this.description = document.get("description").toString();
        this.members = ((ArrayList<Document>) document.get("members")) //todo
                .stream()
                .map(document1 -> new User(document1))
                .collect(Collectors.toList());
    }

    public Team() {
        //dummy constructor for json
    }

    public List<User> getMembers() {
        return members;
    }

    public void setMembers(List members) {
        this.members = members;
    }

    public Team(String name, String description, List<User> members) {
        this.name = name;
        this.description = description;
        this.members = members;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    //todo: refactor mapping
    public Map<String, Object> toMap() {

        //todo: refacotr mapping
        List<Object> membersList = members.stream()
                .map(User::toMap)
                .collect(Collectors.toList());


        return ImmutableMap.<String, Object>builder()
                .put("name", name)
                .put("description", description)
                .put("members", membersList)
                .build();
    }
}
