package resources.tasks;


import core.TaskType;
import io.dropwizard.auth.Auth;
import objects.tasks.Task;
import objects.User;
import repositories.TasksRepository;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

/**
 * Created by gpietrus on 23.02.2016.
 */
@Produces(MediaType.APPLICATION_JSON)
public class CryptoTaskResource extends TaskResource {

    private TasksRepository tasksRepository;

    @Inject
    public CryptoTaskResource(TasksRepository tasksRepository) {
        this.tasksRepository = tasksRepository;
    }

    //todo: merge crypto and web task?
//    @Override
    @Path("crypto/{task_level}")
    @GET
    //todo: auth
    public Response getTask(@Auth User user,
                            final @PathParam("task_level") int taskLevel) {

        Task task = tasksRepository.get(taskLevel);//todo
        if(task != null && task.getTaskType().equals(TaskType.CRYPTO)) {
            return Response.ok().entity(task.getTaskType().getType()).build();
        }
        return Response.status(Response.Status.BAD_REQUEST).build();
    }
}
