package com.telephoners.krakyournet.ctf.resources;

import com.telephoners.krakyournet.ctf.objects.Team;
import com.telephoners.krakyournet.ctf.repositories.TeamsRepository;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.List;

@Singleton
@Path(value = "/teams")
@Produces(MediaType.APPLICATION_JSON)
public class TeamsResource
{
    private TeamsRepository teamsRepository;

    @Inject
    public TeamsResource(TeamsRepository teamsRepository) {
        this.teamsRepository = teamsRepository;
    }

    @GET
    public List<Team> getTeams() {
        return teamsRepository.getAll();
    }

}
