package com.telephoners.krakyournet.ctf.objects.tasks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.telephoners.krakyournet.ctf.core.TaskType;
import com.telephoners.krakyournet.ctf.helpers.PublicProperty;
import com.telephoners.krakyournet.ctf.objects.Flag;
import org.bson.types.ObjectId;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Id;

import java.util.List;

@Entity("tasks")
@JsonInclude(JsonInclude.Include.NON_NULL)
public abstract class Task
{
    @Id
    protected ObjectId id;
    @PublicProperty
    protected String name;
    @PublicProperty
    protected int level;
    protected List<Flag> flags;

    public Task(String name, int level, List<Flag> flags)
    {
        this.name = name;
        this.level = level;
        this.flags = flags;
    }

    public Task()
    {
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public int getLevel()
    {
        return level;
    }

    public void setLevel(int level)
    {
        this.level = level;
    }

    public List<Flag> getFlags()
    {
        return flags;
    }

    public void setFlags(List<Flag> flags)
    {
        this.flags = flags;
    }
}
