package com.telephoners.krakyournet.ctf.beans;


import org.immutables.value.Value;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target({ElementType.PACKAGE, ElementType.TYPE})
@Retention(RetentionPolicy.CLASS) // Make it class retention for incremental compilation
@Value.Style(
        allParameters = true,
        get = {"is*", "get*"},
        init = "with*",
        typeAbstract = {"Abstract*"},
        typeImmutable = "*",
        depluralize = true,
        defaults = @Value.Immutable(
                copy = false
        )
)
public @interface Immutable {}