package repositories;

import database.MongoDBConnector;
import objects.User;
import org.bson.Document;

import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * Created by gpietrus on 20.02.2016.
 */
public class UsersRepository implements Repository {

    private MongoDBConnector mongoDBConnector;

    public UsersRepository(MongoDBConnector mongoDBConnector) {
        this.mongoDBConnector = mongoDBConnector;
    }

    public void get(UUID uuid) {
//        new HashMap<>()
//        return mongoDBConnector.getDocument("");
    }

    public List<User> getAll() {
        return mongoDBConnector.getCollection("users")
                .stream()
                .map((Function<Document, User>) User::new)
                .collect(Collectors.toList());
    }

    public void add(User user) {
        mongoDBConnector.addDocument("users", new Document(user.toMap()));
    }

    public void clean() {
        mongoDBConnector.removeCollection("users");
    }
}
