/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.AggregationOptions;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BulkWriteHelper;
import com.mongodb.BulkWriteOperation;
import com.mongodb.BulkWriteResult;
import com.mongodb.Bytes;
import com.mongodb.CommandResult;
import com.mongodb.CompoundDBObjectCodec;
import com.mongodb.Cursor;
import com.mongodb.DB;
import com.mongodb.DBCollectionObjectFactory;
import com.mongodb.DBCursor;
import com.mongodb.DBDecoderAdapter;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBEncoder;
import com.mongodb.DBEncoderAdapter;
import com.mongodb.DBEncoderFactory;
import com.mongodb.DBEncoderFactoryAdapter;
import com.mongodb.DBObject;
import com.mongodb.DBObjectCodec;
import com.mongodb.DBObjectFactory;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.DefaultDBEncoder;
import com.mongodb.ExplainVerbosity;
import com.mongodb.Function;
import com.mongodb.GroupCommand;
import com.mongodb.InsertOptions;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.MongoBatchCursorAdapter;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoClient;
import com.mongodb.MongoCursorAdapter;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.OperationIterable;
import com.mongodb.ParallelScanOptions;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernException;
import com.mongodb.WriteConcernResult;
import com.mongodb.WriteRequest;
import com.mongodb.WriteResult;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.IndexRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.connection.BufferProvider;
import com.mongodb.operation.AggregateOperation;
import com.mongodb.operation.AggregateToCollectionOperation;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.BaseWriteOperation;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.CountOperation;
import com.mongodb.operation.CreateIndexesOperation;
import com.mongodb.operation.DeleteOperation;
import com.mongodb.operation.DistinctOperation;
import com.mongodb.operation.DropCollectionOperation;
import com.mongodb.operation.DropIndexOperation;
import com.mongodb.operation.FindAndDeleteOperation;
import com.mongodb.operation.FindAndReplaceOperation;
import com.mongodb.operation.FindAndUpdateOperation;
import com.mongodb.operation.FindOperation;
import com.mongodb.operation.InsertOperation;
import com.mongodb.operation.ListIndexesOperation;
import com.mongodb.operation.MapReduceBatchCursor;
import com.mongodb.operation.MapReduceStatistics;
import com.mongodb.operation.MapReduceToCollectionOperation;
import com.mongodb.operation.MapReduceWithInlineResultsOperation;
import com.mongodb.operation.MixedBulkWriteOperation;
import com.mongodb.operation.OperationExecutor;
import com.mongodb.operation.ParallelCollectionScanOperation;
import com.mongodb.operation.RenameCollectionOperation;
import com.mongodb.operation.UpdateOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonInt32;
import org.bson.BsonJavaScript;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.BsonValueCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.Encoder;
import org.bson.types.ObjectId;

@ThreadSafe
public class DBCollection {
    public static final String ID_FIELD_NAME = "_id";
    private final String name;
    private final DB database;
    private final OperationExecutor executor;
    private final Bytes.OptionHolder optionHolder;
    private volatile ReadPreference readPreference;
    private volatile WriteConcern writeConcern;
    private volatile ReadConcern readConcern;
    private List<DBObject> hintFields;
    private DBEncoderFactory encoderFactory;
    private DBDecoderFactory decoderFactory;
    private DBCollectionObjectFactory objectFactory;
    private volatile CompoundDBObjectCodec objectCodec;

    DBCollection(String name, DB database, OperationExecutor executor) {
        this.name = name;
        this.database = database;
        this.executor = executor;
        this.optionHolder = new Bytes.OptionHolder(database.getOptionHolder());
        this.objectFactory = new DBCollectionObjectFactory();
        this.objectCodec = new CompoundDBObjectCodec(this.getDefaultDBObjectCodec());
    }

    protected DBCollection(DB database, String name) {
        this(name, database, database.getExecutor());
    }

    private static BasicDBList toDBList(BatchCursor<DBObject> source) {
        BasicDBList dbList = new BasicDBList();
        while (source.hasNext()) {
            dbList.addAll(source.next());
        }
        return dbList;
    }

    public WriteResult insert(DBObject document, WriteConcern writeConcern) {
        return this.insert(Arrays.asList(document), writeConcern);
    }

    public WriteResult insert(DBObject ... documents) {
        return this.insert(Arrays.asList(documents), this.getWriteConcern());
    }

    public WriteResult insert(WriteConcern writeConcern, DBObject ... documents) {
        return this.insert(documents, writeConcern);
    }

    public WriteResult insert(DBObject[] documents, WriteConcern writeConcern) {
        return this.insert(Arrays.asList(documents), writeConcern);
    }

    public WriteResult insert(List<? extends DBObject> documents) {
        return this.insert(documents, this.getWriteConcern());
    }

    public WriteResult insert(List<? extends DBObject> documents, WriteConcern aWriteConcern) {
        return this.insert(documents, aWriteConcern, null);
    }

    public WriteResult insert(DBObject[] documents, WriteConcern aWriteConcern, DBEncoder encoder) {
        return this.insert(Arrays.asList(documents), aWriteConcern, encoder);
    }

    public WriteResult insert(List<? extends DBObject> documents, WriteConcern aWriteConcern, DBEncoder dbEncoder) {
        return this.insert(documents, new InsertOptions().writeConcern(aWriteConcern).dbEncoder(dbEncoder));
    }

    public WriteResult insert(List<? extends DBObject> documents, InsertOptions insertOptions) {
        WriteConcern writeConcern = insertOptions.getWriteConcern() != null ? insertOptions.getWriteConcern() : this.getWriteConcern();
        Encoder<DBObject> encoder = this.toEncoder(insertOptions.getDbEncoder());
        ArrayList<InsertRequest> insertRequestList = new ArrayList<InsertRequest>(documents.size());
        for (DBObject dBObject : documents) {
            if (dBObject.get(ID_FIELD_NAME) == null) {
                dBObject.put(ID_FIELD_NAME, new ObjectId());
            }
            insertRequestList.add(new InsertRequest(new BsonDocumentWrapper<DBObject>(dBObject, encoder)));
        }
        return this.insert(insertRequestList, writeConcern, insertOptions.isContinueOnError(), insertOptions.getBypassDocumentValidation());
    }

    private Encoder<DBObject> toEncoder(DBEncoder dbEncoder) {
        return dbEncoder != null ? new DBEncoderAdapter(dbEncoder) : this.objectCodec;
    }

    private WriteResult insert(List<InsertRequest> insertRequestList, WriteConcern writeConcern, boolean continueOnError, Boolean bypassDocumentValidation) {
        return this.executeWriteOperation(new InsertOperation(this.getNamespace(), !continueOnError, writeConcern, insertRequestList).bypassDocumentValidation(bypassDocumentValidation));
    }

    WriteResult executeWriteOperation(BaseWriteOperation operation) {
        return this.translateWriteResult(this.executor.execute(operation));
    }

    private WriteResult translateWriteResult(WriteConcernResult writeConcernResult) {
        if (!writeConcernResult.wasAcknowledged()) {
            return WriteResult.unacknowledged();
        }
        return this.translateWriteResult(writeConcernResult.getCount(), writeConcernResult.isUpdateOfExisting(), writeConcernResult.getUpsertedId());
    }

    private WriteResult translateWriteResult(int count, boolean isUpdateOfExisting, BsonValue upsertedId) {
        Object newUpsertedId = upsertedId == null ? null : ((DBObject)this.getObjectCodec().decode(new BsonDocumentReader(new BsonDocument(ID_FIELD_NAME, upsertedId)), DecoderContext.builder().build())).get(ID_FIELD_NAME);
        return new WriteResult(count, isUpdateOfExisting, newUpsertedId);
    }

    public WriteResult save(DBObject document) {
        return this.save(document, this.getWriteConcern());
    }

    public WriteResult save(DBObject document, WriteConcern writeConcern) {
        Object id = document.get(ID_FIELD_NAME);
        if (id == null) {
            return this.insert(document, writeConcern);
        }
        return this.replaceOrInsert(document, id, writeConcern);
    }

    private WriteResult replaceOrInsert(DBObject obj, Object id, WriteConcern writeConcern) {
        BasicDBObject filter = new BasicDBObject(ID_FIELD_NAME, id);
        UpdateRequest replaceRequest = new UpdateRequest(this.wrap(filter), this.wrap(obj, this.objectCodec), WriteRequest.Type.REPLACE).upsert(true);
        return this.executeWriteOperation(new UpdateOperation(this.getNamespace(), false, writeConcern, Arrays.asList(replaceRequest)));
    }

    public WriteResult update(DBObject query, DBObject update, boolean upsert, boolean multi, WriteConcern aWriteConcern) {
        return this.update(query, update, upsert, multi, aWriteConcern, null);
    }

    public WriteResult update(DBObject query, DBObject update, boolean upsert, boolean multi, WriteConcern concern, DBEncoder encoder) {
        return this.updateImpl(query, update, upsert, multi, concern, null, encoder);
    }

    public WriteResult update(DBObject query, DBObject update, boolean upsert, boolean multi, WriteConcern concern, boolean bypassDocumentValidation, DBEncoder encoder) {
        return this.updateImpl(query, update, upsert, multi, concern, bypassDocumentValidation, encoder);
    }

    private WriteResult updateImpl(DBObject query, DBObject update, boolean upsert, boolean multi, WriteConcern concern, Boolean bypassDocumentValidation, DBEncoder encoder) {
        if (update == null) {
            throw new IllegalArgumentException("update can not be null");
        }
        if (query == null) {
            throw new IllegalArgumentException("update query can not be null");
        }
        if (!update.keySet().isEmpty() && update.keySet().iterator().next().startsWith("$")) {
            UpdateRequest updateRequest = new UpdateRequest(this.wrap(query), this.wrap(update, encoder), WriteRequest.Type.UPDATE).upsert(upsert).multi(multi);
            return this.executeWriteOperation(new UpdateOperation(this.getNamespace(), false, concern, Arrays.asList(updateRequest)).bypassDocumentValidation(bypassDocumentValidation));
        }
        UpdateRequest replaceRequest = new UpdateRequest(this.wrap(query), this.wrap(update, encoder), WriteRequest.Type.REPLACE).upsert(upsert);
        return this.executeWriteOperation(new UpdateOperation(this.getNamespace(), true, concern, Arrays.asList(replaceRequest)).bypassDocumentValidation(bypassDocumentValidation));
    }

    public WriteResult update(DBObject query, DBObject update, boolean upsert, boolean multi) {
        return this.update(query, update, upsert, multi, this.getWriteConcern());
    }

    public WriteResult update(DBObject query, DBObject update) {
        return this.update(query, update, false, false);
    }

    public WriteResult updateMulti(DBObject query, DBObject update) {
        return this.update(query, update, false, true);
    }

    public WriteResult remove(DBObject query) {
        return this.remove(query, this.getWriteConcern());
    }

    public WriteResult remove(DBObject query, WriteConcern writeConcern) {
        return this.executeWriteOperation(new DeleteOperation(this.getNamespace(), false, writeConcern, Arrays.asList(new DeleteRequest(this.wrap(query)))));
    }

    public WriteResult remove(DBObject query, WriteConcern writeConcern, DBEncoder encoder) {
        DeleteRequest deleteRequest = new DeleteRequest(this.wrap(query, encoder));
        return this.executeWriteOperation(new DeleteOperation(this.getNamespace(), false, writeConcern, Arrays.asList(deleteRequest)));
    }

    @Deprecated
    public DBCursor find(DBObject query, DBObject projection, int numToSkip, int batchSize, int options) {
        return new DBCursor(this, query, projection, this.getReadPreference()).batchSize(batchSize).skip(numToSkip).setOptions(options);
    }

    @Deprecated
    public DBCursor find(DBObject query, DBObject projection, int numToSkip, int batchSize) {
        return new DBCursor(this, query, projection, this.getReadPreference()).batchSize(batchSize).skip(numToSkip);
    }

    public DBCursor find(DBObject query) {
        return new DBCursor(this, query, null, this.getReadPreference());
    }

    public DBCursor find(DBObject query, DBObject projection) {
        return new DBCursor(this, query, projection, this.getReadPreference());
    }

    public DBCursor find() {
        return this.find(new BasicDBObject());
    }

    public DBObject findOne() {
        return this.findOne(new BasicDBObject());
    }

    public DBObject findOne(DBObject query) {
        return this.findOne(query, null, null, this.getReadPreference());
    }

    public DBObject findOne(DBObject query, DBObject projection) {
        return this.findOne(query, projection, null, this.getReadPreference());
    }

    public DBObject findOne(DBObject query, DBObject projection, DBObject sort) {
        return this.findOne(query, projection, sort, this.getReadPreference());
    }

    public DBObject findOne(DBObject query, DBObject projection, ReadPreference readPreference) {
        return this.findOne(query, projection, null, readPreference);
    }

    public DBObject findOne(DBObject query, DBObject projection, DBObject sort, ReadPreference readPreference) {
        return this.findOne(query, projection, sort, readPreference, this.getReadConcern(), 0L, TimeUnit.MILLISECONDS);
    }

    DBObject findOne(DBObject query, DBObject projection, DBObject sort, ReadPreference readPreference, ReadConcern readConcern, long maxTime, TimeUnit maxTimeUnit) {
        BatchCursor cursor;
        FindOperation<DBObject> operation = new FindOperation<DBObject>(this.getNamespace(), this.objectCodec).readConcern(readConcern).projection(this.wrapAllowNull(projection)).sort(this.wrapAllowNull(sort)).limit(-1).maxTime(maxTime, maxTimeUnit);
        if (query != null) {
            operation.filter(this.wrap(query));
        }
        return (cursor = (BatchCursor)((Object)this.executor.execute(operation, readPreference))).hasNext() ? (DBObject)cursor.next().iterator().next() : null;
    }

    public DBObject findOne(Object id) {
        return this.findOne(id, null);
    }

    public DBObject findOne(Object id, DBObject projection) {
        return this.findOne(new BasicDBObject(ID_FIELD_NAME, id), projection);
    }

    public long count() {
        return this.getCount(new BasicDBObject(), null);
    }

    public long count(DBObject query) {
        return this.getCount(query, null);
    }

    public long count(DBObject query, ReadPreference readPreference) {
        return this.getCount(query, null, readPreference);
    }

    public long getCount() {
        return this.getCount(new BasicDBObject(), null);
    }

    public long getCount(ReadPreference readPreference) {
        return this.getCount(new BasicDBObject(), null, readPreference);
    }

    public long getCount(DBObject query) {
        return this.getCount(query, null);
    }

    public long getCount(DBObject query, DBObject projection) {
        return this.getCount(query, projection, 0L, 0L);
    }

    public long getCount(DBObject query, DBObject projection, ReadPreference readPreference) {
        return this.getCount(query, projection, 0L, 0L, readPreference);
    }

    public long getCount(DBObject query, DBObject projection, long limit, long skip) {
        return this.getCount(query, projection, limit, skip, this.getReadPreference());
    }

    public long getCount(DBObject query, DBObject projection, long limit, long skip, ReadPreference readPreference) {
        return this.getCount(query, limit, skip, readPreference, this.getReadConcern(), 0L, TimeUnit.MILLISECONDS);
    }

    long getCount(DBObject query, long limit, long skip, ReadPreference readPreference, ReadConcern readConcern, long maxTime, TimeUnit maxTimeUnit) {
        return this.getCount(query, limit, skip, readPreference, readConcern, maxTime, maxTimeUnit, null);
    }

    long getCount(DBObject query, long limit, long skip, ReadPreference readPreference, ReadConcern readConcern, long maxTime, TimeUnit maxTimeUnit, BsonValue hint) {
        if (limit > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("limit is too large: " + limit);
        }
        if (skip > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("skip is too large: " + skip);
        }
        CountOperation operation = new CountOperation(this.getNamespace()).readConcern(readConcern).hint(hint).skip(skip).limit(limit).maxTime(maxTime, maxTimeUnit);
        if (query != null) {
            operation.filter(this.wrap(query));
        }
        return this.executor.execute(operation, readPreference);
    }

    public DBCollection rename(String newName) {
        return this.rename(newName, false);
    }

    public DBCollection rename(String newName, boolean dropTarget) {
        this.executor.execute(new RenameCollectionOperation(this.getNamespace(), new MongoNamespace(this.getNamespace().getDatabaseName(), newName)).dropTarget(dropTarget));
        return this.getDB().getCollection(newName);
    }

    public DBObject group(DBObject key, DBObject cond, DBObject initial, String reduce) {
        return this.group(key, cond, initial, reduce, null);
    }

    public DBObject group(DBObject key, DBObject cond, DBObject initial, String reduce, String finalize) {
        return this.group(key, cond, initial, reduce, finalize, this.getReadPreference());
    }

    public DBObject group(DBObject key, DBObject cond, DBObject initial, String reduce, String finalize, ReadPreference readPreference) {
        return this.group(new GroupCommand(this, key, cond, initial, reduce, finalize), readPreference);
    }

    public DBObject group(GroupCommand cmd) {
        return this.group(cmd, this.getReadPreference());
    }

    public DBObject group(GroupCommand cmd, ReadPreference readPreference) {
        return DBCollection.toDBList((BatchCursor)((Object)this.executor.execute(cmd.toOperation(this.getNamespace(), this.getDefaultDBObjectCodec()), readPreference)));
    }

    public List distinct(String fieldName) {
        return this.distinct(fieldName, this.getReadPreference());
    }

    public List distinct(String fieldName, ReadPreference readPreference) {
        return this.distinct(fieldName, new BasicDBObject(), readPreference);
    }

    public List distinct(String fieldName, DBObject query) {
        return this.distinct(fieldName, query, this.getReadPreference());
    }

    public List distinct(String fieldName, DBObject query, ReadPreference readPreference) {
        return new OperationIterable<BsonValue>(new DistinctOperation<BsonValue>(this.getNamespace(), fieldName, new BsonValueCodec()).readConcern(this.getReadConcern()).filter(this.wrap(query)), readPreference, this.executor).map(new Function<BsonValue, Object>(){

            @Override
            public Object apply(BsonValue bsonValue) {
                BsonDocument document = new BsonDocument("value", bsonValue);
                DBObject obj = DBCollection.this.getDefaultDBObjectCodec().decode(new BsonDocumentReader(document), DecoderContext.builder().build());
                return obj.get("value");
            }
        }).into(new ArrayList());
    }

    public MapReduceOutput mapReduce(String map, String reduce, String outputTarget, DBObject query) {
        MapReduceCommand command = new MapReduceCommand(this, map, reduce, outputTarget, MapReduceCommand.OutputType.REDUCE, query);
        return this.mapReduce(command);
    }

    public MapReduceOutput mapReduce(String map, String reduce, String outputTarget, MapReduceCommand.OutputType outputType, DBObject query) {
        MapReduceCommand command = new MapReduceCommand(this, map, reduce, outputTarget, outputType, query);
        return this.mapReduce(command);
    }

    public MapReduceOutput mapReduce(String map, String reduce, String outputTarget, MapReduceCommand.OutputType outputType, DBObject query, ReadPreference readPreference) {
        MapReduceCommand command = new MapReduceCommand(this, map, reduce, outputTarget, outputType, query);
        command.setReadPreference(readPreference);
        return this.mapReduce(command);
    }

    public MapReduceOutput mapReduce(MapReduceCommand command) {
        String action;
        ReadPreference readPreference;
        ReadPreference readPreference2 = readPreference = command.getReadPreference() == null ? this.getReadPreference() : command.getReadPreference();
        if (command.getOutputType() == MapReduceCommand.OutputType.INLINE) {
            MapReduceWithInlineResultsOperation<DBObject> operation = new MapReduceWithInlineResultsOperation<DBObject>(this.getNamespace(), new BsonJavaScript(command.getMap()), new BsonJavaScript(command.getReduce()), this.getDefaultDBObjectCodec());
            operation.readConcern(this.getReadConcern());
            operation.filter(this.wrapAllowNull(command.getQuery()));
            operation.limit(command.getLimit());
            operation.maxTime(command.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            operation.jsMode(command.getJsMode() == null ? false : command.getJsMode());
            operation.sort(this.wrapAllowNull(command.getSort()));
            operation.verbose(command.isVerbose());
            if (command.getScope() != null) {
                operation.scope(this.wrap(new BasicDBObject(command.getScope())));
            }
            if (command.getFinalize() != null) {
                operation.finalizeFunction(new BsonJavaScript(command.getFinalize()));
            }
            MapReduceBatchCursor executionResult = (MapReduceBatchCursor)((Object)this.executor.execute(operation, readPreference));
            return new MapReduceOutput(command.toDBObject(), executionResult);
        }
        switch (command.getOutputType()) {
            case REPLACE: {
                action = "replace";
                break;
            }
            case MERGE: {
                action = "merge";
                break;
            }
            case REDUCE: {
                action = "reduce";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected output type");
            }
        }
        MapReduceToCollectionOperation operation = new MapReduceToCollectionOperation(this.getNamespace(), new BsonJavaScript(command.getMap()), new BsonJavaScript(command.getReduce()), command.getOutputTarget()).filter(this.wrapAllowNull(command.getQuery())).limit(command.getLimit()).maxTime(command.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).jsMode(command.getJsMode() == null ? false : command.getJsMode()).sort(this.wrapAllowNull(command.getSort())).verbose(command.isVerbose()).action(action).databaseName(command.getOutputDB()).bypassDocumentValidation(command.getBypassDocumentValidation());
        if (command.getScope() != null) {
            operation.scope(this.wrap(new BasicDBObject(command.getScope())));
        }
        if (command.getFinalize() != null) {
            operation.finalizeFunction(new BsonJavaScript(command.getFinalize()));
        }
        MapReduceStatistics mapReduceStatistics = this.executor.execute(operation);
        DBCollection mapReduceOutputCollection = this.getMapReduceOutputCollection(command);
        DBCursor executionResult = mapReduceOutputCollection.find();
        return new MapReduceOutput(command.toDBObject(), executionResult, mapReduceStatistics, mapReduceOutputCollection);
    }

    private DBCollection getMapReduceOutputCollection(MapReduceCommand command) {
        String requestedDatabaseName = command.getOutputDB();
        DB database = requestedDatabaseName != null ? this.getDB().getSisterDB(requestedDatabaseName) : this.getDB();
        return database.getCollection(command.getOutputTarget());
    }

    @Deprecated
    public AggregationOutput aggregate(DBObject firstOp, DBObject ... additionalOps) {
        ArrayList<DBObject> pipeline = new ArrayList<DBObject>();
        pipeline.add(firstOp);
        Collections.addAll(pipeline, additionalOps);
        return this.aggregate(pipeline);
    }

    public AggregationOutput aggregate(List<? extends DBObject> pipeline) {
        return this.aggregate(pipeline, this.getReadPreference());
    }

    public AggregationOutput aggregate(List<? extends DBObject> pipeline, ReadPreference readPreference) {
        Cursor cursor = this.aggregate(pipeline, AggregationOptions.builder().outputMode(AggregationOptions.OutputMode.INLINE).build(), readPreference, false);
        if (cursor == null) {
            return new AggregationOutput(Collections.<DBObject>emptyList());
        }
        ArrayList<DBObject> results = new ArrayList<DBObject>();
        while (cursor.hasNext()) {
            results.add((DBObject)cursor.next());
        }
        return new AggregationOutput(results);
    }

    public Cursor aggregate(List<? extends DBObject> pipeline, AggregationOptions options) {
        return this.aggregate(pipeline, options, this.getReadPreference());
    }

    public Cursor aggregate(List<? extends DBObject> pipeline, AggregationOptions options, ReadPreference readPreference) {
        return this.aggregate(pipeline, options, readPreference, true);
    }

    private Cursor aggregate(List<? extends DBObject> pipeline, AggregationOptions options, ReadPreference readPreference, boolean returnCursorForOutCollection) {
        if (options == null) {
            throw new IllegalArgumentException("options can not be null");
        }
        List<BsonDocument> stages = this.preparePipeline(pipeline);
        BsonValue outCollection = stages.get(stages.size() - 1).get("$out");
        if (outCollection != null) {
            AggregateToCollectionOperation operation = new AggregateToCollectionOperation(this.getNamespace(), stages).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).allowDiskUse(options.getAllowDiskUse()).bypassDocumentValidation(options.getBypassDocumentValidation());
            this.executor.execute(operation);
            if (returnCursorForOutCollection) {
                return new DBCursor(this.database.getCollection(outCollection.asString().getValue()), new BasicDBObject(), null, ReadPreference.primary());
            }
            return null;
        }
        AggregateOperation<DBObject> operation = new AggregateOperation<DBObject>(this.getNamespace(), stages, this.getDefaultDBObjectCodec()).readConcern(this.getReadConcern()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).allowDiskUse(options.getAllowDiskUse()).batchSize(options.getBatchSize()).useCursor(options.getOutputMode() == AggregationOptions.OutputMode.CURSOR);
        BatchCursor cursor = (BatchCursor)((Object)this.executor.execute(operation, readPreference));
        return new MongoCursorAdapter(new MongoBatchCursorAdapter<DBObject>(cursor));
    }

    public CommandResult explainAggregate(List<? extends DBObject> pipeline, AggregationOptions options) {
        AggregateOperation<BsonDocument> operation = new AggregateOperation<BsonDocument>(this.getNamespace(), this.preparePipeline(pipeline), new BsonDocumentCodec()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).allowDiskUse(options.getAllowDiskUse());
        return new CommandResult(this.executor.execute(operation.asExplainableOperation(ExplainVerbosity.QUERY_PLANNER), ReadPreference.primaryPreferred()));
    }

    private List<BsonDocument> preparePipeline(List<? extends DBObject> pipeline) {
        if (pipeline.isEmpty()) {
            throw new MongoException("Aggregation pipelines can not be empty");
        }
        ArrayList<BsonDocument> stages = new ArrayList<BsonDocument>();
        for (DBObject dBObject : pipeline) {
            stages.add(this.wrap(dBObject));
        }
        return stages;
    }

    public List<Cursor> parallelScan(ParallelScanOptions options) {
        ArrayList<Cursor> cursors = new ArrayList<Cursor>();
        ParallelCollectionScanOperation<DBObject> operation = new ParallelCollectionScanOperation<DBObject>(this.getNamespace(), options.getNumCursors(), this.objectCodec).readConcern(this.getReadConcern()).batchSize(options.getBatchSize());
        List mongoCursors = (List)((Object)this.executor.execute(operation, options.getReadPreference() != null ? options.getReadPreference() : this.getReadPreference()));
        for (BatchCursor mongoCursor : mongoCursors) {
            cursors.add(new MongoCursorAdapter(new MongoBatchCursorAdapter<DBObject>(mongoCursor)));
        }
        return cursors;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.getNamespace().getFullName();
    }

    public DBCollection getCollection(String name) {
        return this.database.getCollection(this.getName() + "." + name);
    }

    public void createIndex(String name) {
        this.createIndex(new BasicDBObject(name, (Object)1));
    }

    public void createIndex(DBObject keys, String name) {
        this.createIndex(keys, name, false);
    }

    public void createIndex(DBObject keys, String name, boolean unique) {
        BasicDBObject options = new BasicDBObject();
        if (name != null && name.length() > 0) {
            options.put("name", name);
        }
        if (unique) {
            options.put("unique", Boolean.TRUE);
        }
        this.createIndex(keys, options);
    }

    public void createIndex(DBObject keys) {
        this.createIndex(keys, new BasicDBObject());
    }

    public void createIndex(DBObject keys, DBObject options) {
        this.executor.execute(this.createIndexOperation(keys, options));
    }

    public List<DBObject> getHintFields() {
        return this.hintFields;
    }

    public void setHintFields(List<? extends DBObject> indexes) {
        this.hintFields = new ArrayList<DBObject>(indexes);
    }

    public DBObject findAndModify(DBObject query, DBObject sort, DBObject update) {
        return this.findAndModify(query, null, sort, false, update, false, false);
    }

    public DBObject findAndModify(DBObject query, DBObject update) {
        return this.findAndModify(query, null, null, false, update, false, false);
    }

    public DBObject findAndRemove(DBObject query) {
        return this.findAndModify(query, null, null, true, null, false, false);
    }

    public DBObject findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, DBObject update, boolean returnNew, boolean upsert) {
        return this.findAndModify(query, fields, sort, remove, update, returnNew, upsert, 0L, TimeUnit.MILLISECONDS);
    }

    public DBObject findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, DBObject update, boolean returnNew, boolean upsert, WriteConcern writeConcern) {
        return this.findAndModifyImpl(query, fields, sort, remove, update, returnNew, upsert, null, 0L, TimeUnit.MILLISECONDS, writeConcern);
    }

    public DBObject findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, DBObject update, boolean returnNew, boolean upsert, long maxTime, TimeUnit maxTimeUnit) {
        return this.findAndModifyImpl(query, fields, sort, remove, update, returnNew, upsert, null, maxTime, maxTimeUnit, this.getWriteConcern());
    }

    public DBObject findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, DBObject update, boolean returnNew, boolean upsert, long maxTime, TimeUnit maxTimeUnit, WriteConcern writeConcern) {
        return this.findAndModifyImpl(query, fields, sort, remove, update, returnNew, upsert, null, maxTime, maxTimeUnit, writeConcern);
    }

    public DBObject findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, DBObject update, boolean returnNew, boolean upsert, boolean bypassDocumentValidation, long maxTime, TimeUnit maxTimeUnit) {
        return this.findAndModifyImpl(query, fields, sort, remove, update, returnNew, upsert, bypassDocumentValidation, maxTime, maxTimeUnit, this.getWriteConcern());
    }

    public DBObject findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, DBObject update, boolean returnNew, boolean upsert, boolean bypassDocumentValidation, long maxTime, TimeUnit maxTimeUnit, WriteConcern writeConcern) {
        return this.findAndModifyImpl(query, fields, sort, remove, update, returnNew, upsert, bypassDocumentValidation, maxTime, maxTimeUnit, writeConcern);
    }

    private DBObject findAndModifyImpl(DBObject query, DBObject fields, DBObject sort, boolean remove, DBObject update, boolean returnNew, boolean upsert, Boolean bypassDocumentValidation, long maxTime, TimeUnit maxTimeUnit, WriteConcern writeConcern) {
        AsyncWriteOperation<DBObject> operation;
        if (remove) {
            operation = new FindAndDeleteOperation<DBObject>(this.getNamespace(), writeConcern, this.objectCodec).filter(this.wrapAllowNull(query)).projection(this.wrapAllowNull(fields)).sort(this.wrapAllowNull(sort)).maxTime(maxTime, maxTimeUnit);
        } else {
            if (update == null) {
                throw new IllegalArgumentException("Update document can't be null");
            }
            operation = !update.keySet().isEmpty() && update.keySet().iterator().next().charAt(0) == '$' ? new FindAndUpdateOperation<DBObject>(this.getNamespace(), writeConcern, this.objectCodec, this.wrapAllowNull(update)).filter(this.wrap(query)).projection(this.wrapAllowNull(fields)).sort(this.wrapAllowNull(sort)).returnOriginal(!returnNew).upsert(upsert).maxTime(maxTime, maxTimeUnit).bypassDocumentValidation(bypassDocumentValidation) : new FindAndReplaceOperation<DBObject>(this.getNamespace(), writeConcern, this.objectCodec, this.wrap(update)).filter(this.wrapAllowNull(query)).projection(this.wrapAllowNull(fields)).sort(this.wrapAllowNull(sort)).returnOriginal(!returnNew).upsert(upsert).maxTime(maxTime, maxTimeUnit).bypassDocumentValidation(bypassDocumentValidation);
        }
        try {
            return this.executor.execute(operation);
        }
        catch (MongoWriteConcernException e) {
            throw new WriteConcernException(new BsonDocument("code", new BsonInt32(e.getWriteConcernError().getCode())).append("errmsg", new BsonString(e.getWriteConcernError().getMessage())), e.getServerAddress(), e.getWriteResult());
        }
    }

    public DB getDB() {
        return this.database;
    }

    public WriteConcern getWriteConcern() {
        if (this.writeConcern != null) {
            return this.writeConcern;
        }
        return this.database.getWriteConcern();
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public ReadPreference getReadPreference() {
        if (this.readPreference != null) {
            return this.readPreference;
        }
        return this.database.getReadPreference();
    }

    public void setReadPreference(ReadPreference preference) {
        this.readPreference = preference;
    }

    void setReadConcern(ReadConcern readConcern) {
        this.readConcern = readConcern;
    }

    ReadConcern getReadConcern() {
        if (this.readConcern != null) {
            return this.readConcern;
        }
        return this.database.getReadConcern();
    }

    @Deprecated
    public void slaveOk() {
        this.addOption(4);
    }

    public void addOption(int option) {
        this.optionHolder.add(option);
    }

    public void resetOptions() {
        this.optionHolder.reset();
    }

    public int getOptions() {
        return this.optionHolder.get();
    }

    public void setOptions(int options) {
        this.optionHolder.set(options);
    }

    public void drop() {
        this.executor.execute(new DropCollectionOperation(this.getNamespace()));
    }

    public synchronized DBDecoderFactory getDBDecoderFactory() {
        return this.decoderFactory;
    }

    public synchronized void setDBDecoderFactory(DBDecoderFactory factory) {
        this.decoderFactory = factory;
        DBObjectCodec decoder = factory == null || factory == DefaultDBDecoder.FACTORY ? this.getDefaultDBObjectCodec() : new DBDecoderAdapter(factory.create(), this, this.getBufferPool());
        this.objectCodec = new CompoundDBObjectCodec(this.objectCodec.getEncoder(), decoder);
    }

    public synchronized DBEncoderFactory getDBEncoderFactory() {
        return this.encoderFactory;
    }

    public synchronized void setDBEncoderFactory(DBEncoderFactory factory) {
        this.encoderFactory = factory;
        DBObjectCodec encoder = factory == null || factory == DefaultDBEncoder.FACTORY ? this.getDefaultDBObjectCodec() : new DBEncoderFactoryAdapter(this.encoderFactory);
        this.objectCodec = new CompoundDBObjectCodec(encoder, this.objectCodec.getDecoder());
    }

    public List<DBObject> getIndexInfo() {
        return new OperationIterable(new ListIndexesOperation<DBObject>(this.getNamespace(), this.getDefaultDBObjectCodec()), ReadPreference.primary(), this.executor).into(new ArrayList());
    }

    public void dropIndex(DBObject index) {
        this.dropIndex(this.getIndexNameFromIndexFields(index));
    }

    public void dropIndex(String indexName) {
        this.executor.execute(new DropIndexOperation(this.getNamespace(), indexName));
    }

    public void dropIndexes() {
        this.dropIndex("*");
    }

    public void dropIndexes(String indexName) {
        this.dropIndex(indexName);
    }

    public CommandResult getStats() {
        return this.getDB().executeCommand(new BsonDocument("collStats", new BsonString(this.getName())), this.getReadPreference());
    }

    public boolean isCapped() {
        CommandResult commandResult = this.getStats();
        Object cappedField = commandResult.get("capped");
        return cappedField != null && (cappedField.equals(1) || cappedField.equals(true));
    }

    public Class getObjectClass() {
        return this.objectFactory.getClassForPath(Collections.<String>emptyList());
    }

    public void setObjectClass(Class<? extends DBObject> aClass) {
        this.setObjectFactory(this.objectFactory.update(aClass));
    }

    public void setInternalClass(String path, Class<? extends DBObject> aClass) {
        this.setObjectFactory(this.objectFactory.update(aClass, Arrays.asList(path.split("\\."))));
    }

    protected Class<? extends DBObject> getInternalClass(String path) {
        return this.objectFactory.getClassForPath(Arrays.asList(path.split("\\.")));
    }

    public String toString() {
        return "DBCollection{database=" + this.database + ", name='" + this.name + '\'' + '}';
    }

    synchronized DBObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    synchronized void setObjectFactory(DBCollectionObjectFactory factory) {
        this.objectFactory = factory;
        this.objectCodec = new CompoundDBObjectCodec(this.objectCodec.getEncoder(), this.getDefaultDBObjectCodec());
    }

    public BulkWriteOperation initializeOrderedBulkOperation() {
        return new BulkWriteOperation(true, this);
    }

    public BulkWriteOperation initializeUnorderedBulkOperation() {
        return new BulkWriteOperation(false, this);
    }

    BulkWriteResult executeBulkWriteOperation(boolean ordered, Boolean bypassDocumentValidation, List<WriteRequest> writeRequests) {
        return this.executeBulkWriteOperation(ordered, bypassDocumentValidation, writeRequests, this.getWriteConcern());
    }

    BulkWriteResult executeBulkWriteOperation(boolean ordered, Boolean bypassDocumentValidation, List<WriteRequest> writeRequests, WriteConcern writeConcern) {
        try {
            return BulkWriteHelper.translateBulkWriteResult(this.executor.execute(new MixedBulkWriteOperation(this.getNamespace(), BulkWriteHelper.translateWriteRequestsToNew(writeRequests, this.getObjectCodec()), ordered, writeConcern).bypassDocumentValidation(bypassDocumentValidation)), this.getObjectCodec());
        }
        catch (MongoBulkWriteException e) {
            throw BulkWriteHelper.translateBulkWriteException(e, MongoClient.getDefaultCodecRegistry().get(DBObject.class));
        }
    }

    DBObjectCodec getDefaultDBObjectCodec() {
        return new DBObjectCodec(MongoClient.getDefaultCodecRegistry(), DBObjectCodec.getDefaultBsonTypeClassMap(), this.getObjectFactory());
    }

    private <T> T convertOptionsToType(DBObject options, String field, Class<T> clazz) {
        return this.convertToType(clazz, options.get(field), String.format("'%s' should be of class %s", field, clazz.getSimpleName()));
    }

    private <T> T convertToType(Class<T> clazz, Object value, String errorMessage) {
        Object transformedValue = value;
        if (clazz == Boolean.class) {
            if (value instanceof Boolean) {
                transformedValue = value;
            } else if (value instanceof Number) {
                transformedValue = ((Number)value).doubleValue() != 0.0;
            }
        } else if (clazz == Double.class) {
            if (value instanceof Number) {
                transformedValue = ((Number)value).doubleValue();
            }
        } else if (clazz == Integer.class) {
            if (value instanceof Number) {
                transformedValue = ((Number)value).intValue();
            }
        } else if (clazz == Long.class && value instanceof Number) {
            transformedValue = ((Number)value).longValue();
        }
        if (!clazz.isAssignableFrom(transformedValue.getClass())) {
            throw new IllegalArgumentException(errorMessage);
        }
        return (T)transformedValue;
    }

    private CreateIndexesOperation createIndexOperation(DBObject key, DBObject options) {
        IndexRequest request = new IndexRequest(this.wrap(key));
        if (options.containsField("name")) {
            request.name(this.convertOptionsToType(options, "name", String.class));
        }
        if (options.containsField("background")) {
            request.background(this.convertOptionsToType(options, "background", Boolean.class));
        }
        if (options.containsField("unique")) {
            request.unique(this.convertOptionsToType(options, "unique", Boolean.class));
        }
        if (options.containsField("sparse")) {
            request.sparse(this.convertOptionsToType(options, "sparse", Boolean.class));
        }
        if (options.containsField("expireAfterSeconds")) {
            request.expireAfter(this.convertOptionsToType(options, "expireAfterSeconds", Long.class), TimeUnit.SECONDS);
        }
        if (options.containsField("v")) {
            request.version(this.convertOptionsToType(options, "v", Integer.class));
        }
        if (options.containsField("weights")) {
            request.weights(this.wrap(this.convertOptionsToType(options, "weights", DBObject.class)));
        }
        if (options.containsField("default_language")) {
            request.defaultLanguage(this.convertOptionsToType(options, "default_language", String.class));
        }
        if (options.containsField("language_override")) {
            request.languageOverride(this.convertOptionsToType(options, "language_override", String.class));
        }
        if (options.containsField("textIndexVersion")) {
            request.textVersion(this.convertOptionsToType(options, "textIndexVersion", Integer.class));
        }
        if (options.containsField("2dsphereIndexVersion")) {
            request.sphereVersion(this.convertOptionsToType(options, "2dsphereIndexVersion", Integer.class));
        }
        if (options.containsField("bits")) {
            request.bits(this.convertOptionsToType(options, "bits", Integer.class));
        }
        if (options.containsField("min")) {
            request.min(this.convertOptionsToType(options, "min", Double.class));
        }
        if (options.containsField("max")) {
            request.max(this.convertOptionsToType(options, "max", Double.class));
        }
        if (options.containsField("bucketSize")) {
            request.bucketSize(this.convertOptionsToType(options, "bucketSize", Double.class));
        }
        if (options.containsField("dropDups")) {
            request.dropDups(this.convertOptionsToType(options, "dropDups", Boolean.class));
        }
        if (options.containsField("storageEngine")) {
            request.storageEngine(this.wrap(this.convertOptionsToType(options, "storageEngine", DBObject.class)));
        }
        if (options.containsField("partialFilterExpression")) {
            request.partialFilterExpression(this.wrap(this.convertOptionsToType(options, "partialFilterExpression", DBObject.class)));
        }
        return new CreateIndexesOperation(this.getNamespace(), Arrays.asList(request));
    }

    private String getIndexNameFromIndexFields(DBObject index) {
        StringBuilder indexName = new StringBuilder();
        for (String keyNames : index.keySet()) {
            List<Object> validIndexTypes;
            if (indexName.length() != 0) {
                indexName.append('_');
            }
            indexName.append(keyNames).append('_');
            Object keyType = index.get(keyNames);
            if (keyType instanceof Integer) {
                validIndexTypes = Arrays.asList(1, -1);
                if (!validIndexTypes.contains(keyType)) {
                    throw new UnsupportedOperationException("Unsupported index type: " + keyType);
                }
                indexName.append((Integer)keyType);
                continue;
            }
            if (!(keyType instanceof String)) continue;
            validIndexTypes = Arrays.asList("2d", "2dsphere", "text", "geoHaystack", "hashed");
            if (!validIndexTypes.contains(keyType)) {
                throw new UnsupportedOperationException("Unsupported index type: " + keyType);
            }
            indexName.append(((String)keyType).replace(' ', '_'));
        }
        return indexName.toString();
    }

    Codec<DBObject> getObjectCodec() {
        return this.objectCodec;
    }

    OperationExecutor getExecutor() {
        return this.executor;
    }

    MongoNamespace getNamespace() {
        return new MongoNamespace(this.getDB().getName(), this.getName());
    }

    BufferProvider getBufferPool() {
        return this.getDB().getBufferPool();
    }

    BsonDocument wrapAllowNull(DBObject document) {
        if (document == null) {
            return null;
        }
        return this.wrap(document);
    }

    BsonDocument wrap(DBObject document) {
        return new BsonDocumentWrapper<DBObject>(document, this.getDefaultDBObjectCodec());
    }

    BsonDocument wrap(DBObject document, DBEncoder encoder) {
        if (encoder == null) {
            return this.wrap(document);
        }
        return new BsonDocumentWrapper<DBObject>(document, new DBEncoderAdapter(encoder));
    }

    BsonDocument wrap(DBObject document, Encoder<DBObject> encoder) {
        if (encoder == null) {
            return this.wrap(document);
        }
        return new BsonDocumentWrapper<DBObject>(document, encoder);
    }
}

