(function(){
    angular.module('ctfApp').controller('TaskController', ['$scope', '$stateParams', 'APIProvider', 'AppSettings', function($scope, $stateParams, APIProvider, AppSettings) {
        $scope.submitUnknown = false;
        $scope.apiAddress = 'http://' + AppSettings.apiAddress;
        $scope.selectedTaskId = $stateParams.taskLevel;
        console.log('SELECTED TASK ID', $scope.selectedTaskId);
        APIProvider.getTaskById($scope.selectedTaskId, function(data){
            console.log(data);
            $scope.task = data;
        });
        $scope.submitFlag = function(){
            var flag = $('input#flag-to-submit').val();
            $scope.submitUnknown = true;
            APIProvider.submitFlag(flag).success(function(){
                Materialize.toast('Poprawna flaga! :)', 5000, 'toast-success');
                $scope.submitUnknown = false;
            }).error(function(){
                console.log("Flaga zla!");
                Materialize.toast('Błędna flaga! :(', 5000 ,'toast-error');
                $scope.submitUnknown = false;
            });

        };
    }]);
})();