(function(){

    'use strict';

    var app = angular.module('ctfApp', ['ui.router', 'ncy-angular-breadcrumb', 'ngCookies']);

    app.config(function($stateProvider, $urlRouterProvider, $breadcrumbProvider) {

        $urlRouterProvider.otherwise('/home');

        $stateProvider

            .state('home', {
                url: '/home',
                templateUrl: '/page/home.html'
            })

            .state('login', {
                url: '/login',
                templateUrl: '/page/login.html'
            })

            .state('tasks', {
                url: '/tasks',
                templateUrl: '/page/tasks.html'
            })

            .state('task', {
                url: '/task/:taskLevel',
                templateUrl: '/page/task.html'
            })

            .state('scores', {
                url: '/scores',
                templateUrl: '/page/scoresheet.html'
            });

    });

    app.factory('AppSettings', function() {
        return {
            apiAddress: "http://localhost:8080/api/v1"
        }
    });

    app.run(['$rootScope', '$location', '$cookieStore', '$http',
        function ($rootScope, $location, $cookieStore, $http) {
            // keep user logged in after page refresh
            $rootScope.globals = $cookieStore.get('globals') || {};

            if ($rootScope.globals.currentUser) {
                $http.defaults.headers.common['Authorization'] = 'Not-So-Basic ' + $rootScope.globals.currentUser.authdata; // jshint ignore:line
            }

            $rootScope.$on('$locationChangeStart', function (event, next, current) {
                // redirect to login page if not logged in
                console.log('Globale', $rootScope.globals);
                if ($location.path() !== '/login' && !$rootScope.globals.currentUser) {
                    $location.path('/login');
                }
            });

        }]);

})();


