(function(){
    angular.module('ctfApp').controller('NavigationController', ['$scope', '$rootScope', '$location', 'AuthenticationService',
        function($scope, $rootScope, $location, AuthenticationService){

        $scope.logged = $rootScope.globals ? !!$rootScope.globals.currentUser : false;

        $scope.user = $rootScope.globals && $rootScope.globals.currentUser ? $rootScope.globals.currentUser.username : undefined;

        $scope.logout = function(){
            AuthenticationService.logout(function(data){
                console.log("Logged you out... i guess...", data);
                $location.path('/');
            });
        };

        $scope.$watch(function(){
            return $rootScope.globals;
        }, function(){
            $scope.logged = $rootScope.globals ? !!$rootScope.globals.currentUser : false;
            $scope.user = $rootScope.globals && $rootScope.globals.currentUser ? $rootScope.globals.currentUser.username : undefined;
        });


    }]);
})();
