(function(){
    angular.module('ctfApp').controller('LoginController',
        ['$scope', '$rootScope', '$location', 'AuthenticationService',
            function ($scope, $rootScope, $location, AuthenticationService) {
                // reset login status
                AuthenticationService.clearCredentials();

                $scope.login = function () {
                    $scope.dataLoading = true;
                    AuthenticationService.login($scope.username, $scope.password, function(response) {
                        if(response.status == 200) {
                            AuthenticationService.setCredentials($scope.username, $scope.password, response.team);
                            $location.path('/');
                        } else {
                            $scope.error = response.message;
                            $scope.dataLoading = false;
                        }
                    });
                };


            }]);
})();