(function(){
    angular.module('ctfApp').controller('NavigationController', ['$scope', '$rootScope', '$location', 'AuthenticationService', 'NavbarService',
        function($scope, $rootScope, $location, AuthenticationService, NavbarService){

        $scope.logged = $rootScope.globals ? !!$rootScope.globals.currentUser : false;

        $scope.user = $rootScope.globals && $rootScope.globals.currentUser ? $rootScope.globals.currentUser.username : undefined;

        $scope.logout = function(){
            NavbarService.setGuest();
            AuthenticationService.logout(function(data){
                $location.path('');
            });
        };

        $scope.$watch(function(){
            return $rootScope.globals;
        }, function(){
            $scope.logged = $rootScope.globals ? !!$rootScope.globals.currentUser : false;
            $scope.user = $rootScope.globals && $rootScope.globals.currentUser ? $rootScope.globals.currentUser.username : undefined;
        });


    }]);
})();
