package com.telephoners.krakyournet.ctf.beans;

import com.telephoners.krakyournet.ctf.beans.tasks.Task;
import org.ektorp.support.CouchDbDocument;
import org.joda.time.Instant;

import static com.google.common.base.Preconditions.checkNotNull;

public class Solution extends CouchDbDocument
{
    private Task task;
    private Team team;
    private Flag flag;
    private Instant submitionTime;

    public Solution(Team team, Task task, Flag flag)
    {
        this.team = checkNotNull(team);
        this.task = checkNotNull(task);
        this.flag = checkNotNull(flag);
        this.submitionTime = Instant.now();
    }

    public Solution()
    {
    }

    public void setTeam(Team team)
    {
        this.team = team;
    }

    public Task getTask()
    {
        return task;
    }

    public void setTask(Task task)
    {
        this.task = task;
    }

    public Team getTeam()
    {
        return team;
    }

    public Flag getFlag()
    {
        return flag;
    }

    public void setFlag(Flag flag)
    {
        this.flag = flag;
    }

    public Instant getSubmitionTime()
    {
        return submitionTime;
    }

    public void setSubmitionTime(Instant submitionTime)
    {
        this.submitionTime = submitionTime;
    }
}
