package com.telephoners.krakyournet.ctf.exceptions;

import org.ektorp.support.CouchDbDocument;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class ElementAlreadyExistsException extends WebApplicationException
{
    public ElementAlreadyExistsException(final Class<? extends CouchDbDocument> elementName)
    {
        super(Response.status(Response.Status.BAD_REQUEST)
                .entity(String.format("Element %s already exists", elementName.getSimpleName()))
                .type("text/plain")
                .build());
    }
}
