package com.telephoners.krakyournet.ctf.core;

import com.google.inject.Inject;
import org.ektorp.support.CouchDbDocument;

public class DatabaseNameProvider<T extends CouchDbDocument>
{
    private Class<T> type;

    @Inject
    public DatabaseNameProvider(final Class<T> type)
    {
        this.type = type;
    }

    public String get()
    {
        return String.format("%s_database", formatName(type.getTypeName()));
    }

    private String formatName(final String className)
    {
        return className.replace(".","_");
    }
}
