/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.widget.SpinnerAdapter;

public interface ThemedSpinnerAdapter
extends SpinnerAdapter {
    public void setDropDownViewTheme(@Nullable Resources.Theme var1);

    @Nullable
    public Resources.Theme getDropDownViewTheme();

    public static final class Helper {
        private final Context mContext;
        private final LayoutInflater mInflater;
        private LayoutInflater mDropDownInflater;

        public Helper(@NonNull Context context) {
            this.mContext = context;
            this.mInflater = LayoutInflater.from((Context)context);
        }

        public void setDropDownViewTheme(@Nullable Resources.Theme theme) {
            if (theme == null) {
                this.mDropDownInflater = null;
            } else if (theme == this.mContext.getTheme()) {
                this.mDropDownInflater = this.mInflater;
            } else {
                ContextThemeWrapper context = new ContextThemeWrapper(this.mContext, theme);
                this.mDropDownInflater = LayoutInflater.from((Context)context);
            }
        }

        @Nullable
        public Resources.Theme getDropDownViewTheme() {
            return this.mDropDownInflater == null ? null : this.mDropDownInflater.getContext().getTheme();
        }

        @NonNull
        public LayoutInflater getDropDownViewInflater() {
            return this.mDropDownInflater != null ? this.mDropDownInflater : this.mInflater;
        }
    }
}

