package repositories;

import database.MongoDBConnector;
import objects.Solution;
import org.bson.Document;

import javax.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * Created by gpietrus on 20.02.2016.
 */
public class SolutionsRepository implements Repository {
    private MongoDBConnector mongoDBConnector;

    @Inject
    public SolutionsRepository(MongoDBConnector mongoDBConnector) {
        this.mongoDBConnector = mongoDBConnector;
    }

//    public void get(UUID uuid) {
//
//    }

    public List<Solution> getAll() {
        return mongoDBConnector.getCollection("solutions")
                .stream()
                .map(Solution::new)
                .collect(Collectors.toList());
    }

    public void add(Solution solution) { //todo
        //todo: object/string
        Map<String, Object> retypedMap = solution.toMap().entrySet().stream()
                .collect(Collectors.toMap(
                        (Function<Map.Entry<String, String>, String>) Map.Entry::getKey,
                        (Function<Map.Entry<String, String>, Object>) Map.Entry::getValue
                ));
        mongoDBConnector.addDocument("solutions", new Document(retypedMap));
    }

    public void clean() {
        mongoDBConnector.removeCollection("solutions");
    }
}

//todo: generify!