package objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import org.bson.Document;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Created by gpietrus on 20.02.2016.
 */
public class Team {
    private String name;
    private String description;
    private List<User> members;

    public static Team fromDocument(Document document) {
        return new Team(document.get("name").toString(),
                document.get("description").toString(),
                ((ArrayList<Document>) document.get("members")) //todo
                        .stream()
                        .map(User::fromDocument)
                        .collect(Collectors.toList())
                );
        //todo: refactor mapping
    }

    public List<User> getMembers() {
        return members;
    }

    public void setMembers(List members) {
        this.members = members;
    }

    @JsonCreator
    public Team(@JsonProperty("name") String name,
                @JsonProperty("description") String description,
                @JsonProperty("members") List<User> members) {
        this.name = name;
        this.description = description;
        this.members = members;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    //todo: refactor mapping
    public Map<String, Object> toMap() {

        //todo: refacotr mapping
        List<Object> membersList = members.stream()
                .map(User::toMap)
                .collect(Collectors.toList());


        return ImmutableMap.<String, Object>builder()
                .put("name", name)
                .put("description", description)
                .put("members", membersList)
                .build();
    }
}
