package objects;

import com.google.common.collect.ImmutableMap;
import core.TaskType;
import org.bson.Document;

import java.util.Map;

/**
 * Created by gpietrus on 20.02.2016.
 */
public class Task {
    private String name;
    private int level;
    private TaskType type;

    public Task(Document document) {

        this.name = document.get("name").toString();
        this.level = (int) document.get("level");
        this.type = TaskType.valueOf(document.get("type").toString());
    }

    public TaskType getType() {
        return type;
    }

    public Task(String name, int level, TaskType type) {
        this.name = name;
        this.level = level;
        this.type = type;
    }

    public void setType(TaskType type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    //todo: refactor mapping
    public Map<String, Object> toMap() {
        return ImmutableMap.<String, Object>builder()
                .put("name", name)
                .put("level", level)
                .put("type", type.getType())
                .build();
    }
}
