package commands;

import com.google.inject.Guice;
import com.google.inject.Injector;
import core.ApplicationConfiguration;
import io.dropwizard.cli.ConfiguredCommand;
import io.dropwizard.setup.Bootstrap;
import modules.ApplicationModule;
import net.sourceforge.argparse4j.inf.Namespace;
import org.mongodb.morphia.Datastore;

public class PurgeDatabaseCommand extends ConfiguredCommand<ApplicationConfiguration>
{
    private static final String COMMAND_NAME = "purgedb";
    private static final String COMMAND_DESCRIPTION = "Purge database";

    public PurgeDatabaseCommand()
    {
        super(COMMAND_NAME, COMMAND_DESCRIPTION);
    }

    @Override
    protected void run(Bootstrap<ApplicationConfiguration> bootstrap, Namespace namespace, ApplicationConfiguration applicationConfiguration) throws Exception
    {
        Injector injector = Guice.createInjector(new ApplicationModule(applicationConfiguration));
        Datastore datastore = injector.getInstance(Datastore.class);
        datastore.getDB().dropDatabase();
    }
}
