package auth;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.basic.BasicCredentials;
import objects.User;
import repositories.UsersRepository;


public class ExampleAuthenticator implements Authenticator<BasicCredentials, User> {

    private UsersRepository usersRepository;

    @Inject
    public ExampleAuthenticator(UsersRepository usersRepository) {
        this.usersRepository = usersRepository;
    }

    @Override
    public com.google.common.base.Optional<User> authenticate(BasicCredentials credentials) throws AuthenticationException {
        User user = usersRepository.authenticateUser(credentials);
        if (user != null) {
            return Optional.of(user);
        }
        return Optional.absent();
    }
}