package com.telephoners.krakyournet.ctf.commands;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.telephoners.krakyournet.ctf.core.ApplicationConfiguration;
import com.telephoners.krakyournet.ctf.modules.ApplicationModule;
import io.dropwizard.cli.ConfiguredCommand;
import io.dropwizard.setup.Bootstrap;
import net.sourceforge.argparse4j.inf.Namespace;

public class PurgeDatabaseCommand extends ConfiguredCommand<ApplicationConfiguration>
{
    private static final String COMMAND_NAME = "purgedb";
    private static final String COMMAND_DESCRIPTION = "Purge database";

    public PurgeDatabaseCommand()
    {
        super(COMMAND_NAME, COMMAND_DESCRIPTION);
    }

    @Override
    protected void run(Bootstrap<ApplicationConfiguration> bootstrap, Namespace namespace, ApplicationConfiguration applicationConfiguration) throws Exception
    {
        Injector injector = Guice.createInjector(new ApplicationModule(applicationConfiguration));
//        Datastore datastore = injector.getInstance(Datastore.class);
//        datastore.getDB().dropDatabase();
    }
}
