package core;

import helpers.TextTaskConfig;
import helpers.WebTaskConfig;
import io.dropwizard.Configuration;
import objects.Team;
import objects.User;

import java.util.List;

public class ApplicationConfiguration extends Configuration
{
    private String dbHost;
    private int dbPort;
    private String dbName;
    private String flagHashMethod;
    private List<Team> teams;
    private List<TextTaskConfig> textTasks;
    private List<WebTaskConfig> webTasks;
    private List<User> admins;

    public List<User> getAdmins()
    {
        return admins;
    }

    public void setAdmins(List<User> admins)
    {
        this.admins = admins;
    }

    public List<TextTaskConfig> getTextTasks()
    {
        return textTasks;
    }

    public void setTextTasks(List<TextTaskConfig> textTasks)
    {
        this.textTasks = textTasks;
    }

    public List<WebTaskConfig> getWebTasks()
    {
        return webTasks;
    }

    public void setWebTasks(List<WebTaskConfig> webTasks)
    {
        this.webTasks = webTasks;
    }

    public String getFlagHashMethod()
    {
        return flagHashMethod;
    }

    public List<Team> getTeams()
    {
        return teams;
    }

    public void setTeams(List<Team> teams)
    {
        this.teams = teams;
    }

    public void setFlagHashMethod(String flagHashMethod)
    {
        this.flagHashMethod = flagHashMethod;
    }

    public String getDbHost()
    {
        return dbHost;
    }

    public void setDbHost(String dbHost)
    {
        this.dbHost = dbHost;
    }

    public int getDbPort()
    {
        return dbPort;
    }

    public void setDbPort(int dbPort)
    {
        this.dbPort = dbPort;
    }

    public String getDbName()
    {
        return dbName;
    }

    public void setDbName(String dbName)
    {
        this.dbName = dbName;
    }
}
