module.exports = function(grunt) {
    grunt.initConfig({
        pkg: grunt.file.readJSON('package.json'),
        cssmin: {
            task: {
                src: [
                    './service/src/main/resources/assets/statics/css/*',
                    './service/src/main/resources/assets/statics/libs/*.css'
                ],
                dest: './service/src/main/resources/assets_build/statics/css/main.min.css'
            },
            options: {
                'banner': null,
                'keepSpecialComments': '*',
                'report': 'min'
            }
        },
        copy: {
            main: {
                files: [
                    // includes files within path
                    {expand: true, flatten: true, src: ['service/src/main/resources/assets/statics/img/**'], dest: 'service/src/main/resources/assets_build/statics/img/', filter: 'isFile'}
                ]
            }
        },
        htmlmin: {
            target: {
                options: {
                    removeComments: true,
                    collapseWhitespace: true
                },
                files: {
                    './service/src/main/resources/assets_build/index.html': './service/src/main/resources/assets/index.html',
                    './service/src/main/resources/assets_build/about.html': './service/src/main/resources/assets/about.html',
                    './service/src/main/resources/assets_build/home.html': './service/src/main/resources/assets/home.html',
                    './service/src/main/resources/assets_build/login.html': './service/src/main/resources/assets/login.html',
                    './service/src/main/resources/assets_build/scoresheet.html': './service/src/main/resources/assets/scoresheet.html',
                    './service/src/main/resources/assets_build/submitflag.html': './service/src/main/resources/assets/submitflag.html',
                    './service/src/main/resources/assets_build/task.html': './service/src/main/resources/assets/task.html',
                    './service/src/main/resources/assets_build/tasks.html': './service/src/main/resources/assets/tasks.html'
                }
            }
        },
        jshint: {
            files: ['./service/src/main/resources/assets/statics/js/main.js',
                './service/src/main/resources/assets/statics/js/services/*.js',
                './service/src/main/resources/assets/statics/js/providers/*.js',
                './service/src/main/resources/assets/statics/js/utils/*.js',
                './service/src/main/resources/assets/statics/js/controllers/*.js'
            ],
            options: {
                globals: {
                    jQuery: true
                }
            }
        },
        //todo: add clean?
        uglify: {
            task: {
                src: [
                    './service/src/main/resources/assets/statics/js/main.js',
                    './service/src/main/resources/assets/statics/js/services/*.js',
                    './service/src/main/resources/assets/statics/js/providers/*.js',
                    './service/src/main/resources/assets/statics/js/utils/*.js',
                    './service/src/main/resources/assets/statics/js/controllers/*.js',
                    './service/src/main/resources/assets/statics/libs/*.js'
                ],
                dest: './service/src/main/resources/assets_build/statics/js/app.min.js'
            },
            options: {
                'mangle': false,
                'compress': {},
                'beautify': false,
                'expression': false,
                'report': 'min',
                'sourceMap': false,
                'sourceMapName': undefined,
                'sourceMapIn': undefined,
                'sourceMapIncludeSources': false,
                'enclose': undefined,
                'wrap': undefined,
                'exportAll': false,
                'preserveComments': undefined,
                'banner': '',
                'footer': ''
            }
        }
    });


    //todo: add clean
    grunt.loadNpmTasks('grunt-contrib-jshint');
    grunt.loadNpmTasks('grunt-contrib-cssmin');
    grunt.loadNpmTasks('grunt-contrib-uglify');
    grunt.loadNpmTasks('grunt-contrib-htmlmin');
    grunt.loadNpmTasks('grunt-contrib-copy');

    grunt.registerTask('default', ['jshint', 'copy', 'htmlmin', 'cssmin', 'uglify']);
};