package com.telephoners.krakyournet.ctf.providers;

import com.mongodb.MongoClient;
import com.telephoners.krakyournet.ctf.core.ApplicationConfiguration;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;

import javax.inject.Inject;

public class DatastoreProvider
{
    private final ApplicationConfiguration applicationConfiguration;

    @Inject
    public DatastoreProvider(ApplicationConfiguration applicationConfiguration)
    {
        this.applicationConfiguration = applicationConfiguration;
    }

    public Datastore getDatastore()
    {
        Morphia morphia = new Morphia();
        Datastore datastore = morphia.createDatastore(
                new MongoClient(applicationConfiguration.getDbHost(), applicationConfiguration.getDbPort()), applicationConfiguration.getDbName());
        datastore.ensureIndexes();
        return datastore;
    }
}
