package repositories;

import core.FlagChecker;
import database.MongoDBConnector;
import objects.Task;
import org.bson.Document;

import javax.inject.Inject;
import java.util.*;
import java.util.stream.Collectors;

/**
 * Created by gpietrus on 20.02.2016.
 */
public class TasksRepository implements Repository {

    private final FlagChecker flagChecker;
    private MongoDBConnector mongoDBConnector;

    @Inject
    public TasksRepository(MongoDBConnector mongoDBConnector, FlagChecker flagChecker) {
        this.mongoDBConnector = mongoDBConnector;
        this.flagChecker = flagChecker;
    }

    public void get(UUID uuid) {

    }

    public List<Task> getAll() {
        return mongoDBConnector.getCollection("tasks")
                .stream()
                .map(Task::new)
                .collect(Collectors.toList());
    }

    public void add(Task task) {
        mongoDBConnector.addDocument("tasks", new Document(task.toMap()));
    }

    public void clean() {
        mongoDBConnector.removeCollection("tasks");
    }

    public Set<Map.Entry<Task, String>> getUserFlagsHashes(String username) {
        return this.getAll().stream()
                .collect(Collectors.toMap(
                        task -> task,
                        task -> flagChecker.calculateHashValue(username, task.getFlag().getValue())
                ))
                .entrySet();
    }
}

//todo: generify!