package objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import org.bson.Document;

import java.security.Principal;
import java.util.Map;

/**
 * Created by gpietrus on 16.02.16.
 */
public class User implements Principal {
    private String name;
    private String password;
    private String email;

    public static User fromDocument(Document document) {
        return new User(document.get("name").toString(),
                document.get("password").toString(),
                document.get("password").toString()
        );
    }

    @JsonCreator
    public User(@JsonProperty("name") String name,
                @JsonProperty("password") String password,
                @JsonProperty("email") String email) {
        this.name = name;
        this.password = password;
        this.email = email;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    //todo: refactor mapping
    public Map<String, Object> toMap() {
        return ImmutableMap.<String, Object>builder()
                .put("name", name)
                .put("password", password)
                .build();
    }

    //todo: contructor fromMap
}
