import auth.ExampleAuthenticator;
import com.bazaarvoice.dropwizard.webjars.WebJarBundle;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.mongodb.MongoClient;
import core.ApplicationConfiguration;
import io.dropwizard.Application;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.auth.AuthDynamicFeature;
import io.dropwizard.auth.AuthValueFactoryProvider;
import io.dropwizard.auth.Authorizer;
import io.dropwizard.auth.basic.BasicCredentialAuthFilter;
import io.dropwizard.jersey.setup.JerseyEnvironment;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import objects.User;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;
import repositories.SolutionsRepository;
import repositories.TasksRepository;
import repositories.TeamsRepository;
import repositories.UsersRepository;
import resources.*;

import java.util.stream.Stream;

/**
 * Created by gpietrus on 16.02.16.
 */
public class CTFApplication extends Application<ApplicationConfiguration> {

    private Morphia morphia;
    private Datastore datastore;
    private UsersRepository usersRepository; //todo: refactor to injects
    private TasksRepository tasksRepository; //todo: refactor to injects
    private TeamsRepository teamsRepository;
    private SolutionsRepository solutionsRepository;
    private Injector injector;


    //todo: move initalization to repositories
    @Override
    public void initialize(final Bootstrap<ApplicationConfiguration> bootstrap) {
        bootstrap.addBundle(new AssetsBundle("/assets", "/page", "index.html"));
        Stream.of("org.webjars.npm", "org.webjars.bower")
                .map(WebJarBundle::new)
                .forEach(bootstrap::addBundle);
    }

    private void initializeMorhpia() {
        morphia = new Morphia();
        morphia.mapPackage("objects.Team");
        datastore = morphia.createDatastore(new MongoClient(), "db"); //todo: db name from conf
        datastore.ensureIndexes();
    }

    private void registerResources(Environment environment) {
        JerseyEnvironment jersey = environment.jersey();
        jersey.register(injector.getInstance(TeamsResource.class));
        jersey.register(injector.getInstance(TasksResource.class));
        jersey.register(injector.getInstance(ProxyResource.class));
        jersey.register(injector.getInstance(SolutionsResource.class));
        jersey.register(injector.getInstance(TaskResource.class));
    }

    private void registerAuthFeatures(Environment environment) {
        environment.jersey().register(new AuthDynamicFeature(
                new BasicCredentialAuthFilter.Builder<User>()
                        .setAuthenticator(injector.getInstance(ExampleAuthenticator.class))
                        .setAuthorizer(new ExampleAuthorizer())
                        .setRealm("SUPER SECRET STUFF")
                        .buildAuthFilter()));
        environment.jersey().register(RolesAllowedDynamicFeature.class);
        environment.jersey().register(new AuthValueFactoryProvider.Binder<>(User.class));
    }

    @Override
    public void run(ApplicationConfiguration applicationConfiguration, Environment environment) throws Exception {
        //todo: refactor
        initializeMorhpia();
        injector = createInjector(applicationConfiguration, datastore);

        registerResources(environment);
        registerAuthFeatures(environment);
    }

    //todo: move to seperate class


    public class ExampleAuthorizer implements Authorizer<User> {
        @Override
        public boolean authorize(User user, String role) {
            return user.getName().equals("good-guy") && role.equals("ADMIN");
        }

    }

    private Injector createInjector(ApplicationConfiguration applicationConfiguration, Datastore datastore) {
        return Guice.createInjector(new AbstractModule() {
            @Override
            protected void configure() {
                bind(ApplicationConfiguration.class).toInstance(applicationConfiguration); //todo: refactor
                bind(Datastore.class).toInstance(datastore);
            }
        });
    }

    public static void main(String[] args) throws Exception {
        new CTFApplication().run(args);
    }
}
