package repositories;

import database.MongoDBConnector;
import objects.Team;
import objects.User;
import org.bson.Document;

import javax.inject.Inject;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * Created by gpietrus on 20.02.2016.
 */
public class TeamsRepository implements Repository {

    private MongoDBConnector mongoDBConnector;

    @Inject
    public TeamsRepository(MongoDBConnector mongoDBConnector) {
        this.mongoDBConnector = mongoDBConnector;
    }

    public Team getTeamByUser(String username) {
        return getAll().stream()
                .filter(team -> team.getMembers().stream()
                        .map(User::getName)
                        .collect(Collectors.toList())
                        .contains(username))
                .findFirst()
                .get();
    }

    public void get(UUID uuid) {

    }

    public List<Team> getAll() {
        return mongoDBConnector.getCollection("teams")
                .stream()
                .map(Team::fromDocument)
                .collect(Collectors.toList());
    }

    public void add(Team team) {
        mongoDBConnector.addDocument("teams", new Document(team.toMap()));
    }

    public void clean() {
        mongoDBConnector.removeCollection("teams");
    }

}
