package com.telephoners.krakyournet.ctf.resources;

import com.telephoners.krakyournet.ctf.beans.User;
import com.telephoners.krakyournet.ctf.beans.tasks.Task;
import com.telephoners.krakyournet.ctf.beans.tasks.TaskRequestContext;
import com.telephoners.krakyournet.ctf.beans.tasks.TaskResponse;
import com.telephoners.krakyournet.ctf.helpers.StreamUtils;
import com.telephoners.krakyournet.ctf.repositories.TasksRepository;
import io.dropwizard.auth.Auth;
import org.glassfish.jersey.server.ContainerRequest;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import java.io.IOException;

@Singleton
@Path(value = "/task")
public class TaskResource
{
    private final TasksRepository tasksRepository;
    private static final String KYN_HEADER_NAME = "KYN_2016"; //todo, move to configuration

    @Inject
    public TaskResource(TasksRepository tasksRepository)
    {
        this.tasksRepository = tasksRepository;
    }

    //todo: name
    private TaskResponse getTaskResponse(int taskLevel, TaskRequestContext taskRequestContext) throws IOException
    {
        Task task = tasksRepository.getByLevel(taskLevel);
        return task.getTaskResponse(taskRequestContext);
    }
/*
    @Path("{task_level}/{path: .*}")
    @GET
    public Response getTaskGet(@Auth User user,
                            final @PathParam("task_level") int taskLevel,
                            final @PathParam("path") String path,
                            @Context ContainerRequestContext containerRequestContext) throws IOException
    {
        String kynHeaderValue = taskResponse.getKynHeader();
        if (kynHeaderValue != null) {
            responseBuilder.header(KYN_HEADER_NAME, kynHeaderValue);
        }
        return responseBuilder.build();
    }
    */

    @Path("{task_level}/{path: .*}")
    @GET
    public Response getTaskGet(@Auth User user,
                                final @PathParam("task_level") int taskLevel,
                                final @PathParam("path") String path,
                                @Context ContainerRequestContext containerRequestContext) throws IOException
    {
        String fullPath = path;
        String query = ((ContainerRequest)containerRequestContext).getRequestUri().getQuery();
        if(query != null) {
            fullPath += query;
        }
        TaskRequestContext taskRequestContext = new TaskRequestContext()
                .withHttpMethod("POST")
                .withUser(user)
                .withPath(fullPath);


        TaskResponse taskResponse = getTaskResponse(taskLevel, taskRequestContext);
        //todo: headers
        return Response.ok().entity(taskResponse.getText()).build();
    }

    @Path("{task_level}/{path: .*}")
    @POST
    public Response getTaskPost(@Auth User user,
                            final @PathParam("task_level") int taskLevel,
                            final @PathParam("path") String path,
                            @Context ContainerRequestContext containerRequestContext) throws IOException
    {
        String fullPath = path;
        String query = ((ContainerRequest)containerRequestContext).getRequestUri().getQuery();
        if(query != null) {
            fullPath += query;
        }
        String body = StreamUtils.readStream(containerRequestContext.getEntityStream());
        //todo: TaskContextFrom
        TaskRequestContext taskRequestContext = new TaskRequestContext()
                .withHttpMethod("POST")
                .withUser(user)
                .withPath(fullPath)
                .withBody(body);
        TaskResponse taskResponse = getTaskResponse(taskLevel, taskRequestContext);
        //todo: hedaers
        return Response.ok().entity(taskResponse.getText()).build();
    }
}
