package com.telephoners.krakyournet.ctf.beans.tasks;

import com.telephoners.krakyournet.ctf.beans.User;

public class TaskRequestContext
{
    private String httpMethod; //todo: use class
    private User user;
    private String path;
    private String body;

    public TaskRequestContext withHttpMethod(String httpMethod)
    {
        this.httpMethod = httpMethod;
        return this;
    }

    public TaskRequestContext withUser(User user)
    {
        this.user = user;
        return this;
    }

    public TaskRequestContext withPath(String path)
    {
        this.path = path;
        return this;
    }

    public TaskRequestContext withBody(String body) {
        this.body = body;
        return this;
    }

    public String getHttpMethod()
    {
        return httpMethod;
    }

    public User getUser()
    {
        return user;
    }

    public String getPath()
    {
        return path;
    }

    public String getBody()
    {
        return body;
    }
}
